import datetime

from pydantic import BaseConfig, BaseModel
from app.models.common import PeeweeGetterDict

def convert_datetime_to_realword(dt: datetime.datetime) -> str:
    return dt.replace(tzinfo=datetime.timezone.utc).isoformat().replace("+00:00", "Z")


def convert_field_to_camel_case(string: str) -> str:
    return "".join(
        word.capitalize() if index != 0 else word
        for index, word in enumerate(string.split("_"))
    )


class RWModel(BaseModel):
    class Config(BaseConfig):
        allow_population_by_field_name = True
        json_encoders = {datetime.datetime: convert_datetime_to_realword}
        alias_generator = convert_field_to_camel_case
        getter_dict = PeeweeGetterDict
